/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

public class PgsComboBoxButtonUI
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public PgsComboBoxButtonUI() {
        super("");
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){

            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        };
        this.setModel(defaultButtonModel);
    }

    public PgsComboBoxButtonUI(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this();
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public PgsComboBoxButtonUI(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, cellRendererPane, jList);
        this.iconOnly = bl;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        boolean bl = PgsUtils.isLeftToRight(this.comboBox);
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.top + insets.bottom);
        if (n4 <= 0 || n3 <= 0) {
            return;
        }
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n5 + (n3 - 1);
        int n8 = n6 + (n4 - 1);
        int n9 = 0;
        int n10 = n2 = bl ? n7 : n5;
        if (this.comboIcon != null) {
            n9 = this.comboIcon.getIconWidth();
            int n11 = this.comboIcon.getIconHeight();
            int n12 = 0;
            if (this.iconOnly) {
                n2 = this.getWidth() / 2 - n9 / 2;
                n12 = this.getHeight() / 2 - n11 / 2 - 1;
            } else {
                n2 = bl ? this.getWidth() / 2 - n9 / 2 : n5;
                n12 = n6 + (n8 - n6) / 2 - n11 / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n2, n12);
        }
    }
}

